# -*- coding: utf-8 -*-
from ladon.ladonizer import ladonize
from mysite.pywebsv.utils import request_valid, user_photo, interface_response, SUCCESS_CODE, MESSAGE_CODE, \
    SYSTEM_EXCEPTION, DATA_EXCEPTION, online_employee
import json
from django.utils.translation import ugettext_lazy as _


class BioTimeAppReport(object):

    """
    【Report】考勤报表
    """

    @request_valid
    @ladonize(int, str, str, str, rtype=str)
    def fields(self, source, device_token, language, token):
        """
        获取报表字段
        @param source:          数据来源(1: IOS， 2：Android)
        @param device_token:    消息推送Token
        @param language:
        @param token:
        @rtype:返回请求结果
            请求成功
                {"code":1,"error":"","describe":"","message":"","data":[{"field":"字段", "field_name": "字段名称"}, ]}　字段默认全选
            请求失败
                {"code": -10001, "error": "", "describe": "异常详情", "message": "弹窗信息", "data":""}
        """
        data = [
            {'field': 'pin', 'field_name': u'{0}'.format(_(u'人员编号'))},
            {'field': 'name', 'field_name': u'{0}'.format(_(u'姓名'))},
            {'field': 'att_date', 'field_name': u'{0}'.format(_(u'日期'))},
            {'field': 'check_in', 'field_name': u'{0}'.format(_(u'上班签到'))},
            {'field': 'break_out', 'field_name': u'{0}'.format(_(u'外出'))},
            {'field': 'break_in', 'field_name': u'{0}'.format(_(u'外出返回'))},
            {'field': 'check_out', 'field_name': u'{0}'.format(_(u'下班签退'))},
            {'field': 'break_time', 'field_name': u'{0}'.format(_(u'休息时间'))},
            {'field': 'total_time', 'field_name': u'{0}'.format(_(u'总时间'))},
            {'field': 'leave_time', 'field_name': u'{0}'.format(_(u'请假'))},
            {'field': 'overtime', 'field_name': u'{0}'.format(_(u'加班'))},
        ]
        return interface_response(SUCCESS_CODE, json.dumps(data), '', 'successful')

    @request_valid
    @ladonize(long, long, str, str, str, int, str, str, str, rtype=str)
    def display(self, start, end, search, field, department, source, device_token, language, token):
        """
        @param start:           开始日期(stamp)
        @param end:             结束日期(stamp)
        @param search:          查询条件(工号/姓名)
        @param field:           查询字段, 用　,　连接
        @param department:      查询部门, 用  ,  连接
        @param source:          数据来源(1: IOS， 2：Android)
        @param device_token:    消息推送Token
        @param language:
        @param token:
        @rtype:返回请求结果
            请求成功
                {"code":1,"error":"","describe":"","message":"","data":{"address":"报表请求地址链接"}}
            请求失败
                {"code": -10001, "error": "", "describe": "异常详情", "message": "弹窗信息", "data":""}
        """
        emp = online_employee()
        print "[*]Pin:", emp.PIN
        address = '/webservice/rpc/app/att/AppReport/?pure&fields={0}&department={1}&start={2}&end={3}&userid={4}'.format(field, department, start, end, emp.pk)
        print "[*]Search:{0}".format(search)
        print "[*]Report address:{0}".format(address)
        return interface_response(SUCCESS_CODE, json.dumps({'address': address}), '', 'successful')

